/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.UpdateException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.ModelUnit;
import com.quantumdata.sct.dao.jaxb.ModelUnits;
import com.quantumdata.sct.dao.jaxb.ModelUnitsType;
import com.quantumdata.sct.dao.vo.ModelUnitVO;
import com.quantumdata.sct.dao.vo.UnitVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import com.quantumdata.sct.util.keygen.RandTSKeyGenerator;
import java.util.ArrayList;
import java.util.Iterator;

public class ModelUnitDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = RandTSKeyGenerator.instance();

    public void readCallback() throws DAOException {
        try {
            ModelUnits modelUnits = (ModelUnits)this.daoObject;
            int n = modelUnits.getModelUnitCollection().size();
            this.daoCollection.clear();
            for (int i = 0; i < n; ++i) {
                ModelUnitsType.ModelUnit modelUnit = (ModelUnitsType.ModelUnit)((ModelUnits)this.daoObject).getModelUnitCollection().get(i);
                this.daoCollection.put(modelUnit.getModelId(), new Integer(i));
            }
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    public IPersistable getValueObjectForKey(Object object) throws CreateException {
        try {
            return this.findByPrimaryKey((String)object);
        }
        catch (Exception exception) {
            throw new CreateException("Unable to create with key =" + object, null, exception);
        }
    }

    public IPersistable[] findByAll() throws Exception {
        int n = ((ModelUnits)this.daoObject).getModelUnitCollection().size();
        IPersistable[] iPersistableArray = new IPersistable[n];
        for (int i = 0; i < n; ++i) {
            ModelUnitsType.ModelUnit modelUnit = (ModelUnitsType.ModelUnit)((ModelUnits)this.daoObject).getModelUnitCollection().get(i);
            iPersistableArray[i] = this.createPersistable(modelUnit);
        }
        return iPersistableArray;
    }

    public Object getUniqueKey(Object object) {
        Object object2 = null;
        if (object instanceof ModelUnitsType.ModelUnit) {
            ModelUnitsType.ModelUnit modelUnit = (ModelUnitsType.ModelUnit)object;
            object2 = modelUnit.getModelId();
        } else {
            object2 = this.getUniqueKey();
        }
        return object2;
    }

    public final IPersistable createPersistable(Object object) {
        ModelUnitVO modelUnitVO = new ModelUnitVO();
        if (object instanceof ModelUnitsType.ModelUnit) {
            this.copyFrom((ModelUnitsType.ModelUnit)object, modelUnitVO);
        }
        return modelUnitVO;
    }

    protected void copyFrom(ModelUnitsType.ModelUnit modelUnit, ModelUnitVO modelUnitVO) {
        modelUnitVO.setId(modelUnit.getModelId());
        modelUnitVO.setLastUpdate(modelUnit.getLastUpdate());
        ArrayList<UnitVO> arrayList = new ArrayList<UnitVO>();
        for (ModelUnit.Unit unit : modelUnit.getUnit()) {
            UnitVO unitVO = new UnitVO();
            unitVO.setUnitId(unit.getId());
            unitVO.setSerialNumber(unit.getSerialNumber());
            arrayList.add(unitVO);
        }
        modelUnitVO.setUnits(arrayList);
    }

    protected void copyTo(ModelUnitsType.ModelUnit modelUnit, ModelUnitVO modelUnitVO) throws Exception {
        modelUnit.setModelId(modelUnitVO.getModelId());
        modelUnit.setLastUpdate(modelUnitVO.getLastUpdate());
        Iterator iterator = modelUnitVO.getUnits().iterator();
        while (iterator.hasNext()) {
            ModelUnit.Unit unit = this.factory.createModelUnitUnit();
            UnitVO unitVO = (UnitVO)iterator.next();
            unit.setId(unitVO.getUnitId());
            unit.setSerialNumber(unitVO.getSerialNumber());
            modelUnit.getUnit().add(unit);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void update(IPersistable iPersistable) throws UpdateException {
        if (!(iPersistable instanceof ModelUnitVO)) throw new UpdateException("Invalid Object", null);
        try {
            ModelUnitVO modelUnitVO = (ModelUnitVO)iPersistable;
            if (!this.daoCollection.containsKey(modelUnitVO.getId()) || !modelUnitVO.isDirty()) return;
            Object v = this.daoCollection.get(modelUnitVO.getId());
            System.out.println(v.getClass().getName());
            Integer n = (Integer)this.daoCollection.get(modelUnitVO.getId());
            ModelUnitsType.ModelUnit modelUnit = (ModelUnitsType.ModelUnit)((ModelUnits)this.daoObject).getModelUnitCollection().get(n);
            modelUnit.getUnit().clear();
            this.copyTo(modelUnit, modelUnitVO);
            this.flush();
            return;
        }
        catch (Exception exception) {
            throw new UpdateException(exception.getMessage(), null, exception);
        }
    }

    protected void updateObject(IPersistable iPersistable) throws Exception {
        if (this.daoCollection.containsKey(iPersistable.getId())) {
            Integer n = (Integer)this.daoCollection.get(iPersistable.getId());
            ModelUnitsType.ModelUnit modelUnit = (ModelUnitsType.ModelUnit)((ModelUnits)this.daoObject).getModelUnitCollection().get(n);
            this.copyTo(modelUnit, (ModelUnitVO)iPersistable);
        }
    }

    protected final IPersistable findByPrimaryKey(String string) {
        ModelUnitVO modelUnitVO = null;
        if (this.daoCollection.containsKey(string)) {
            Integer n = (Integer)this.daoCollection.get(string);
            ModelUnitsType.ModelUnit modelUnit = (ModelUnitsType.ModelUnit)((ModelUnits)this.daoObject).getModelUnitCollection().get(n);
            ModelUnitVO modelUnitVO2 = new ModelUnitVO();
            this.copyFrom(modelUnit, modelUnitVO2);
            modelUnitVO = modelUnitVO2;
        }
        return modelUnitVO;
    }

    protected final void removeByPrimaryKey(Object object) throws DAOException {
        try {
            if (object instanceof String) {
                int n = (Integer)this.daoCollection.get(object);
                ((ModelUnits)this.daoObject).getModelUnitCollection().remove(n);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DAOException(throwable.getMessage());
        }
    }

    public void add(IPersistable iPersistable, int n) throws CreateException {
        try {
            int n2 = ((ModelUnits)this.daoObject).getModelUnitCollection().size();
            if (!(iPersistable instanceof ModelUnitVO) || n >= n2) {
                throw new Exception("Invalid parameters being passed");
            }
            ModelUnitsType.ModelUnit modelUnit = this.factory.createModelUnitsTypeModelUnit();
            this.copyTo(modelUnit, (ModelUnitVO)iPersistable);
            ((ModelUnits)this.daoObject).getModelUnitCollection().add(n, modelUnit);
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }

    public void add(IPersistable iPersistable) throws CreateException {
        try {
            if (!(iPersistable instanceof ModelUnitVO)) {
                throw new Exception("Invalid Value Object being passed");
            }
            ModelUnitsType.ModelUnit modelUnit = this.factory.createModelUnitsTypeModelUnit();
            this.copyTo(modelUnit, (ModelUnitVO)iPersistable);
            ((ModelUnits)this.daoObject).getModelUnitCollection().add(modelUnit);
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }
}

